# Ear Candy - Pulseaduio sound managment tool
# Copyright (C) 2008 Jason Taylor
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys
try:
     import pygtk
     pygtk.require("2.0")
except:
      pass
try:
    import gtk
    import gtk.glade
except:
    sys.exit(1)

import re
import copy

from glade_window import GladeWindow
from window.WindowWatcher import WindowWatcher

from Client import Client

class EarCandyClientProperties(GladeWindow):
    def __init__(self, core, client, parent):
        
        self.core = core
        
        GladeWindow.__init__(self, "pulseoptions.glade", "window_client_properties", parent)
        
        self.entry_description = self.wtree.get_widget("entry_description")
        self.image_icon = self.wtree.get_widget("image_icon")
        self.hscale_max_volume = self.wtree.get_widget("hscale_max_volume")
        self.entry_window_title = self.wtree.get_widget("entry_window_title")
        self.entry_command = self.wtree.get_widget("entry_command")
        self.entry_application = self.wtree.get_widget("entry_application")
        self.label_name = self.wtree.get_widget("label_name")
        self.entry_name = self.wtree.get_widget("entry_name")
        self.combobox_category = self.wtree.get_widget("combobox_category")
        self.checkbutton_fix = self.wtree.get_widget("checkbutton_fix")
        self.checkbutton_fade_volume = self.wtree.get_widget("checkbutton_fade_volume")
        self.combobox_output = self.wtree.get_widget("combobox_output")

        signals = {
            "on_button_close_clicked" : self.on_button_close_clicked,
            "on_button_apply_clicked" : self.on_button_apply_clicked
        }
        self.wtree.signal_autoconnect(signals)

        self.entry_description.set_text(client.description)

        self.window.set_title("Ear Candy : " + client.description)

        self.image_icon.set_from_pixbuf(client.icon)
        
        self.hscale_max_volume.set_value( client.volume_default )

        self.entry_window_title.set_text( client.rule_re_window_title.pattern )
        
        self.entry_command.set_text( client.rule_re_command.pattern )

        self.entry_application.set_text( client.rule_re_application.pattern )

        self.label_name.set_markup("<b><big>" + client.description + "</big></b>")

        self.entry_name.set_text(client.name)

        self.checkbutton_fix.set_active( client.apply_volume_meter_hack )

        self.checkbutton_fade_volume.set_active( client.fade_volume )

        count = 0
        for value in self.core.display.values():
            self.combobox_category.append_text(value)
            if self.core.display[client.category] == value: self.combobox_category.set_active(count)
            count = count + 1
        
        self.client = client

        count = 1
        self.combobox_output.set_active(0 )
        for key in self.core.pa_output_descriptions.keys():
            self.combobox_output.append_text(self.core.pa_output_descriptions[key])
            if self.core.pa_outputs[key] == client.output: 
                self.combobox_output.set_active(count)
            count = count + 1

    def on_button_close_clicked(self, widget):
        self.stop()

    def on_button_apply_clicked(self, widget):
        self.client.description = self.entry_description.get_text()
        self.client.volume_default = int(self.hscale_max_volume.get_value())
        self.client.rule_re_window_title = re.compile( self.entry_window_title.get_text() )
        self.client.rule_re_command = re.compile( self.entry_command.get_text() )
        self.client.rule_re_application = re.compile( self.entry_application.get_text() )
        self.client.name = self.entry_name.get_text()
        self.client.apply_volume_meter_hack = self.checkbutton_fix.get_active()
        self.client.fade_volume = self.checkbutton_fade_volume.get_active()

        self.client.output = ""
        for key in self.core.pa_output_descriptions.keys():
            if self.core.pa_output_descriptions[key] == self.combobox_output.get_active_text():
                self.client.output = self.core.pa_outputs[key]

        self.client.category = ""
        for key in self.core.display.keys():
            if self.core.display[key] == self.combobox_category.get_active_text():
                self.client.category = key

        self.stop()
